unit Formini;


interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs;


type
  TWhatSave = (size, location, state);
  STWhatSave = set of TWhatSave;

Const
  WHATSAVE_ALL = [size, location, state];

type
  Tformini = class(Tcomponent)
   private
    TheApp: Tapplication;
    myform: Tform;
    saveformshow:Tnotifyevent;
    saveformclose:Tcloseevent;
    mIniFile: string;
    mIniSect: string[80];
    FlocalDir: boolean;       {If localDir is true, ini dir is the app dir.
                               Else, ini dir is the windows dir.}
    Fwhat: Stwhatsave;
   protected
   public
    constructor create( aowner: tcomponent); override;
    destructor destroy; override;
    procedure SaveWin(TheForm: TForm; What: STWhatSave);
    procedure RestoreWin( TheForm: TForm; What: STWhatSave);
    procedure FormShow(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
   published
    property localdir:boolean read Flocaldir write Flocaldir default true;
    property whattosave:Stwhatsave read Fwhat write Fwhat default whatsave_all;
   end;


procedure Register;

implementation

Uses IniFiles;


procedure Register;
begin
  RegisterComponents('Samples', [Tformini]);
end;

destructor Tformini.Destroy;
begin
  if not (csDesigning in ComponentState) then begin
    myform.onshow:=saveformshow;
    myform.onclose:=saveformclose;
    end;
  inherited Destroy;
end;


constructor Tformini.create( aowner: tcomponent);
      {If localDir is true, ini dir is the app dir.
      Else, ini dir is the windows dir.}

var
  fname, path: string[100];


begin
  inherited create(aowner);

  myform:=aowner as tform;  (* raise exeption if owner is not a tform *)
  theapp:=aowner.owner as Tapplication;  (* as above if form
                                   is not owned by tapplication *)
  localdir:=true;
  whattosave:=WHATSAVE_ALL;
  if not (csDesigning in ComponentState) then begin
    saveformshow:=myform.onshow;
    myform.onshow:=formshow;
    saveformclose:= myform.onclose;
    myform.onclose:=formclose;
    end;
  localdir:=true;

  {Calculate ini file name}

  fname := ChangeFileExt( ExtractFileName( TheApp.exeName), '.INI');
  if FlocalDir then begin {parse out path and add to file name}
    path := ExtractFilePath(TheApp.exeName);
    if path[length(path)] <> '\' then
      path := path + '\';
    fname := path + fname;
  end;
{fill object fields}
  mIniFile := fname;
  mIniSect := 'formini';
end;

procedure Tformini.RestoreWin( TheForm: TForm; What: STWhatSave);
var
  FormNm, SectionNm: string[80];
  ini: TIniFile;
  n,l,t,w,h: integer; {Left, Top Width, Height}

begin
  ini := TIniFile.create( mIniFile);
  TRY
    SectionNm := mIniSect;
    FormNm := TheForm.classname;

{Update Window State if Necessary}
    if state in What then
      n := ini.ReadInteger( SectionNm, FormNm + '_WindowState', 0);
      case  n of
        1:   TheForm.WindowState := wsMinimized;
        2:   TheForm.WindowState := wsNormal;
        3:   TheForm.WindowState := wsMaximized;
      end;

{Update Size and Location if necessary.}

    with TheForm do begin l:=left; t:=top; h:=height; w:=width; end; {Save current vals.}

    if size in What then begin
      w := ini.ReadInteger( SectionNm, FormNm + '_Width', w);
      h := ini.ReadInteger( SectionNm, FormNm + '_Height', h);
    end;
    if location in What then begin
      t := ini.ReadInteger( SectionNm, FormNm + '_Top', t);
      l := ini.ReadInteger( SectionNm, FormNm + '_Left', l);
    end;

    TheForm.SetBounds(l,t,w,h);
  FINALLY
    ini.free;
  END;
end;

procedure Tformini.SaveWin(TheForm: TForm; What: STWhatSave);
var
  FormNm, SectionNm: string[80];
  ini: TIniFile;

begin
  ini := TIniFile.create( mIniFile);
  TRY
    SectionNm := mIniSect;
    FormNm := TheForm.ClassName;
    if size in what then begin
      ini.WriteInteger( SectionNm, FormNm + '_Width', TheForm.Width);
      ini.WriteInteger( SectionNm, FormNm + '_Height', TheForm.Height);
    end;
    if location in what then begin
      ini.WriteInteger( SectionNm, FormNm + '_Top', TheForm.Top);
      ini.WriteInteger( SectionNm, FormNm + '_Left', TheForm.Left);
    end;
    if state in what then
      case TheForm.WindowState of
        wsMinimized:   ini.WriteInteger( SectionNm, FormNm + '_WindowState', 1);
        wsNormal:     ini.WriteInteger( SectionNm, FormNm + '_WindowState', 2);
        wsMaximized:   ini.WriteInteger( SectionNm, FormNm + '_WindowState', 3);
      end;
  FINALLY
    ini.free;
  END;
end;

procedure TFormini.FormShow(Sender: TObject);
begin
  RestoreWin(myform, whattosave);
  if assigned(saveformshow) then saveformshow(sender);
end;

procedure TFormini.FormClose(Sender: TObject; var Action: TCloseAction);
begin
   SaveWin(myform, whattosave);
   if assigned(saveformclose) then saveformclose(sender,action);
end;

end.


